/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.StringDescription;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasPropertyWithValueTest
extends AbstractMatcherTest {
    private final BeanWithoutInfo shouldMatch = new BeanWithoutInfo("is expected");
    private final BeanWithoutInfo shouldNotMatch = new BeanWithoutInfo("not expected");
    private final BeanWithInfo beanWithInfo = new BeanWithInfo("with info");

    @Override
    protected Matcher<?> createMatcher() {
        return HasPropertyWithValue.hasProperty((String)"irrelevant", (Matcher)IsAnything.anything());
    }

    public void testMatchesInfolessBeanWithMatchedNamedProperty() {
        HasPropertyWithValueTest.assertMatches("with property", HasPropertyWithValue.hasProperty((String)"property", (Matcher)IsEqual.equalTo((Object)"is expected")), this.shouldMatch);
        HasPropertyWithValueTest.assertMismatchDescription("property 'property' was \"not expected\"", HasPropertyWithValue.hasProperty((String)"property", (Matcher)IsEqual.equalTo((Object)"is expected")), this.shouldNotMatch);
    }

    public void testMatchesBeanWithInfoWithMatchedNamedProperty() {
        HasPropertyWithValueTest.assertMatches("with bean info", HasPropertyWithValue.hasProperty((String)"property", (Matcher)IsEqual.equalTo((Object)"with info")), this.beanWithInfo);
        HasPropertyWithValueTest.assertMismatchDescription("property 'property' was \"with info\"", HasPropertyWithValue.hasProperty((String)"property", (Matcher)IsEqual.equalTo((Object)"without info")), this.beanWithInfo);
    }

    public void testDoesNotMatchInfolessBeanWithoutMatchedNamedProperty() {
        HasPropertyWithValueTest.assertMismatchDescription("No property \"nonExistentProperty\"", HasPropertyWithValue.hasProperty((String)"nonExistentProperty", (Matcher)IsAnything.anything()), this.shouldNotMatch);
    }

    public void testDoesNotMatchWriteOnlyProperty() {
        HasPropertyWithValueTest.assertMismatchDescription("property \"writeOnlyProperty\" is not readable", HasPropertyWithValue.hasProperty((String)"writeOnlyProperty", (Matcher)IsAnything.anything()), this.shouldNotMatch);
    }

    public void testDescribeTo() {
        HasPropertyWithValueTest.assertDescription("hasProperty(\"property\", <true>)", HasPropertyWithValue.hasProperty((String)"property", (Matcher)IsEqual.equalTo((Object)true)));
    }

    public void testMatchesPropertyAndValue() {
        HasPropertyWithValueTest.assertMatches("property with value", HasPropertyWithValue.hasProperty((String)"property", (Matcher)IsAnything.anything()), this.beanWithInfo);
    }

    public void testDoesNotWriteMismatchIfPropertyMatches() {
        StringDescription description = new StringDescription();
        HasPropertyWithValue.hasProperty((String)"property", (Matcher)IsAnything.anything()).describeMismatch((Object)this.beanWithInfo, (Description)description);
        HasPropertyWithValueTest.assertEquals((String)"Expected mismatch description", (String)"", (String)description.toString());
    }

    public void testDescribesMissingPropertyMismatch() {
        HasPropertyWithValueTest.assertMismatchDescription("No property \"honk\"", HasPropertyWithValue.hasProperty((String)"honk", (Matcher)IsAnything.anything()), this.shouldNotMatch);
    }

    public void testCanAccessAnAnonymousInnerClass() {
        class X
        implements IX {
            X() {
            }

            public int getTest() {
                return 1;
            }
        }
        MatcherAssert.assertThat((Object)new X(), (Matcher)HasPropertyWithValue.hasProperty((String)"test", (Matcher)IsEqual.equalTo((Object)1)));
    }

    public static class BeanWithInfoBeanInfo
    extends SimpleBeanInfo {
        public PropertyDescriptor[] getPropertyDescriptors() {
            try {
                return new PropertyDescriptor[]{new PropertyDescriptor("property", BeanWithInfo.class, "property", null)};
            }
            catch (IntrospectionException e) {
                throw new RuntimeException("Introspection exception: " + e.getMessage());
            }
        }
    }

    public static class BeanWithInfo {
        private final String propertyValue;

        public BeanWithInfo(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String property() {
            return this.propertyValue;
        }
    }

    public static class BeanWithoutInfo {
        private String property;

        public BeanWithoutInfo(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setWriteOnlyProperty(float property) {
        }

        public String toString() {
            return "[Person: " + this.property + "]";
        }
    }

    static interface IX {
        public int getTest();
    }
}

